#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Sphere Intrusion VariantMod01.fsh  by   andrinr 
//https://www.shadertoy.com/view/3dKfRK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.942477  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Constants

float planetSize = 0.04;
vec3 planetCenter = vec3(0,0,-0.06);


/////////////////////////////////////////////////////////////


float map(vec3 p){
    //sphere
    vec3 q = p + planetCenter;
    
    // Map cartesian to spherical coordinate system
    // https://en.wikipedia.org/wiki/Spherical_coordinate_system#Cartesian_coordinates
    float r = length(q);
    float a = atan(q.y/q.x) + iTime*0.03*p.z;
    float b = atan(length(q.xy)/q.z) + iTime*0.1;
    
    float d = texture2D(iChannel0,vec2(a,b)/3.141).x;
    return length(q) - planetSize + 0.02*d; 
} 


// Raytracer
float trace(vec3 origin, vec3 ray){ 
    float t = 0.; 
    for (int i = 0; i < 64; ++i){ 	
        vec3 p = origin + ray * t; 
        float d = map(p);
        t += d*0.4; 
    } return t; 
} 

//void mainImage( out vec4 fragColor, in vec2 fragCoord ) { 
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1) 
    vec2 uv = fragCoord/iResolution.xy; 
    uv = uv * 2.0 - 1.0; 
    uv.x *= iResolution.x / iResolution.y; 
    
    // Start raytracer
    vec3 ray = normalize(vec3(uv, 1.0)); 
    float rotSpeed = 0.4;
    vec3 origin = vec3(0,0,0); 
    float t = trace(origin, ray); 
    
    vec3 surface = origin + ray * t;
    
    
    // Calculate fog
    float fog = 1.0 / (1.0 + t*t*400.); 
    vec3 fc = vec3(fog); 
    // Output to screen 
    fragColor = vec4(fc,1.0); 
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

